class AcousticSoundWave extends DeusExProjectile;

var float mpDamage;
var int NumWallHits;
var bool bCanHitInstigator, bHitWater;
var name SecondaryDamageType;

simulated function Tick(float deltaTime)
{
	local float value;
	local float sizeMult;

	// don't Super.Tick() becuase we don't want gravity to affect the stream
        if (Level.NetMode != NM_Standalone)
         ImpactSound = None; 

	time += deltaTime / 4;

	value = 1.0+time;
	if (MinDrawScale > 0)
		sizeMult = MaxDrawScale/MinDrawScale;
	else
		sizeMult = 1;

	DrawScale = (-sizeMult/(value*value) + (sizeMult+1))*MinDrawScale;
	ScaleGlow = Default.ScaleGlow/(value*value*value);
}

/////////////////////////////////////////////////////
auto simulated state Flying
{
	simulated function ProcessTouch (Actor Other, Vector HitLocation)
	{
          
		if ( bCanHitInstigator || (Other != Instigator) && (Other != Owner) && (!Other.IsA('Projectile'))) 
		{
			if ( Role == ROLE_Authority )
			{
				Other.TakeDamage(damage, instigator,HitLocation,(MomentumTransfer * Normal(Velocity)), DamageType );
				Other.TakeDamage(damage, instigator,HitLocation,(MomentumTransfer * Normal(Velocity)), SecondaryDamageType );
			}
			if (Role == ROLE_Authority)
			{
            if (damagee.IsA('Pawn') && !damagee.IsA('Robot') && bBlood)
               SpawnBlood(HitLocation, Normal(HitLocation-damagee.Location));
			}
				PlaySound(ImpactSound, SLOT_Misc, 2.0);
        if (Level.NetMode == NM_Standalone)
        {
			NumWallHits++;
			Velocity -= 2 * (Velocity dot HitLocation) * HitLocation;  
        }
		}
	}

	simulated function HitWall (vector HitNormal, actor Wall)
	{
		local vector Vel2D, Norm2D;

        if (Level.NetMode == NM_Standalone)
        {
		PlaySound(ImpactSound, SLOT_Misc, 2.0);
		if ( (Mover(Wall) != None) && Mover(Wall).bDamageTriggered )
		{
			if ( Role == ROLE_Authority )
				Wall.TakeDamage( Damage, instigator, Location, MomentumTransfer * Normal(Velocity), 'shot');
			return;
		}
		NumWallHits++;
		SetTimer(0, False);
		MakeNoise(0.3);
		if ( NumWallHits > 4 )
			Destroy();

		if ( NumWallHits == 1 ) 
		{
			Spawn(class'RockChip',,,Location, rotator(HitNormal));
			Vel2D = Velocity;
			Vel2D.Z = 0;
			Norm2D = HitNormal;
			Norm2D.Z = 0;
			Norm2D = Normal(Norm2D);
			Vel2D = Normal(Vel2D);
			if ( (Vel2D Dot Norm2D) < -0.999 )
			{
				HitNormal = Normal(HitNormal + 0.6 * Vel2D);
				Norm2D = HitNormal;
				Norm2D.Z = 0;
				Norm2D = Normal(Norm2D);
				if ( (Vel2D Dot Norm2D) < -0.999 )
				{
					if ( Rand(1) == 0 )
						HitNormal = HitNormal + vect(0.05,0,0);
					else
						HitNormal = HitNormal - vect(0.05,0,0);
					if ( Rand(1) == 0 )
						HitNormal = HitNormal + vect(0,0.05,0);
					else
						HitNormal = HitNormal - vect(0,0.05,0);
					HitNormal = Normal(HitNormal);
				}
			}
		}
		Velocity -= 2 * (Velocity dot HitNormal) * HitNormal;  
        }
        else
         Destroy();
	}
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
	{
		Damage = mpDamage;
			}
}

defaultproperties
{
     mpDamage=10.000000
     bBlood=False
     bDebris=False
     DamageType=TearGas
     SecondaryDamageType=NanoVirus
     AccurateRange=19200
     maxRange=19200
     bIgnoresNanoDefense=True
     ItemName="|p4Acoustic Guitar"
     ItemArticle="an"
     speed=2048.000000
     MaxSpeed=2048.000000
     Damage=0.000000
     MomentumTransfer=10000
     LifeSpan=14.000000
     DrawType=DT_Sprite
     DrawScale=1.500000
     AmbientGlow=167
     bUnlit=True
     bBounce=True
     Skin=Texture'MSGuitar1_1.Effects.AcousticWave'
     Texture=Texture'MSGuitar1_1.Effects.AcousticWave'
     Style=STY_Translucent
}
